////////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) since 1999. VASCO DATA SECURITY
// All rights reserved. http://www.vasco.com
//
////////////////////////////////////////////////////////////////////////////////

#import <Foundation/Foundation.h>
#import <MSSOrchestration/CryptoAppIndex.h>
NS_ASSUME_NONNULL_BEGIN

@protocol ActivationDelegate;

/**
 * <p>An {@link ActivationParams} object provides parameters for an activation process.</p>
 *
 * <p><b>Note:</b>an instance of this class must be provided to the {@link OrchestrationProtocol} instance when starting the activation process (using ({@link OrchestrationProtocol#startActivation:(ActivationParams *)}).</p>
 */

NS_REFINED_FOR_SWIFT
@interface ActivationParams : NSObject

/**
 * {@link ActivationDelegate} that will be used during activation.
 */
@property (nonatomic, weak, readonly) id<ActivationDelegate> activationDelegate;

/**
 * The cryptographic application index that the should be used during post activation.
 */
@property (nonatomic) CryptoAppIndex cryptoAppIndex;

@end

NS_ASSUME_NONNULL_END
